Imports System.Data.SqlClient
Public Class Main
    Dim con As SqlConnection
    Private Sub Main_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Declarations
        Dim strSQLConnection As String

        ' Open SQL Server connection
        strSQLConnection = InputBox("Change connection string, if necessary", "Specify connection to server and database", "Server=(local)\SQLEXPRESS;Initial Catalog=Security Model;Integrated Security=SSPI")

        ' Connection string to locate server, database, and security 
        con = New SqlConnection(strSQLConnection)

        ' Fill User
        FillUser()

        ' Fill Role
        FillRole()

        ' Fill View
        FillView()

        ' Fill UserRole
        FillUserRole()

        ' Fill AccessColumn
        FillAccessColumn()

        ' Fill RoleAccessColumn (RoleAccessRow is not part of this app but it's easy to do)
        FillRoleAccessColumn()

        ' Fill RoleAccessSelectFilter
        FillRoleAccessSelectFilter()

        ' Fill message box
        Call lblMsg_Click(sender, e)
    End Sub
    Private Sub lblRoleAccessSelect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblRoleAccessSelect.Click
        ' Declarations
        Dim cmd As New SqlCommand("", con)
        Dim str(3) As String
        Dim strSQL As String
        Dim strSQL1 As String
        Dim strSQL2 As String
        Dim strSQL3 As String

        ' Check what parameters have been selected when building SQL string
        ' Put in dummy true condition for those that haven't been selected
        strSQL1 = "(1=1)"
        strSQL2 = "(1=1)"
        strSQL3 = "(1=1)"

        If lbUser.SelectedItems.Count > 0 Then
            strSQL1 = "(lkpUser.UserName = '" & lbUser.SelectedItem.ToString & "')"
        End If

        If lbRole.SelectedItems.Count > 0 Then
            strSQL2 = "(lkpRole.RoleName = '" & lbRole.SelectedItem.ToString & "')"
        End If

        If lbView.SelectedItems.Count > 0 Then
            strSQL3 = "(lkpView.ViewName = '" & lbView.SelectedItem.ToString & "')"
        End If

        ' Build SQL string
        ' Use DISTINCT because different users may have same Role and View
        strSQL = "SELECT DISTINCT lkpRole.RoleName, lkpView.ViewName, Employee.LastName, tblRoleAccessSelect.SelectId FROM Employee INNER JOIN tblRoleAccessSelect ON Employee.EmployeeId = tblRoleAccessSelect.SelectId INNER JOIN lkpRole ON tblRoleAccessSelect.RoleId = lkpRole.RoleId INNER JOIN tblUserRole ON lkpRole.RoleId = tblUserRole.RoleId INNER JOIN lkpView ON tblRoleAccessSelect.ViewId = lkpView.ViewId INNER JOIN lkpUser ON tblUserRole.UserId = lkpUser.UserId WHERE " & strSQL1 & " AND " & strSQL2 & " AND " & strSQL3 & " ORDER BY lkpRole.RoleName, lkpView.ViewName, Employee.LastName"

        ' Display SQL string
        tbSQLString.Text = strSQL

        ' Assign SQL string to command 
        cmd.CommandText = strSQL

        ' Open connection
        con.Open()

        ' Fill result box
        lvRoleAccessSelect.Items.Clear()
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str(0) = reader.Item(0).ToString
            str(1) = reader.Item(1).ToString
            str(2) = reader.Item(2).ToString
            lvRoleAccessSelect.Items.Add(New ListViewItem(New String() {str(0), str(1), str(2)}))
        End While
        reader.Close()

        ' Close connection
        con.Close()

        ' Display number of records
        tbRoleAccessSelectCount.Text = lvRoleAccessSelect.Items.Count
    End Sub
    Private Sub lbUser_DoubleClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lbUser.DoubleClick
        lbUser.ClearSelected()
    End Sub
    Private Sub lbRole_DoubleClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lbRole.DoubleClick
        lbRole.ClearSelected()
    End Sub
    Private Sub lbView_DoubleClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lbView.DoubleClick
        lbView.ClearSelected()
    End Sub
    Private Sub lvRoleAccessSelectFilter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lvRoleAccessSelectFilter.Click
        '
        ' Display SQL for selected filter 
        '

        ' Declarations
        Dim cmd As New SqlCommand("", con)
        Dim prm As SqlClient.SqlParameter
        Dim str As String

        ' Define parameter for stored proc
        prm = New SqlClient.SqlParameter("@objname", SqlDbType.NVarChar)
        prm.Value = lvRoleAccessSelectFilter.SelectedItems.Item(0).SubItems.Item(2).Text

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "SP_HELPTEXT"
        cmd.Parameters.Add(prm)

        ' Open connection
        con.Open()

        ' Call system stored proc and output result to message box
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        tbMsg.Clear()
        While reader.Read()
            str = reader.Item(0).ToString
            tbMsg.AppendText(str)
        End While
        reader.Close()

        ' Expose lblExecute
        lblExecute.Visible = True

        ' Close connection
        con.Close()
    End Sub
    Private Sub lblMsg_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblMsg.Click
        ' Display notes about this program
        Dim strMsg(17) As String ' Number of lines
        Dim I As Integer
        tbMsg.Clear()
        strMsg(0) = "NOTES" & vbCrLf & vbCrLf
        strMsg(1) = "Select zero or more of User, Role, View and press RoleAccessSelect" & vbCrLf & vbCrLf
        strMsg(2) = "Double-click User, Role, or View to undo restrictions" & vbCrLf & vbCrLf
        strMsg(3) = "Use the SQL window to view current RoleAccessSelect query on server" & vbCrLf & vbCrLf
        strMsg(4) = "Filters added to RoleAccessSelectFilter must already exist on server (currently not checked)" & vbCrLf & vbCrLf
        strMsg(5) = "Each filter must select unique records from gateway table" & vbCrLf & vbCrLf
        strMsg(6) = "Each filter must output one integer column called SelectId (representing gateway key)" & vbCrLf & vbCrLf
        strMsg(7) = "Each filter appearing in RoleAccessSelectFilter must not be modified because RoleAccessSelect will not be auto updated" & vbCrLf & vbCrLf
        strMsg(8) = "Each record in RoleAccessSelectFilter must not be modified because RoleAccessSelect will not be auto updated (only add/delete is allowed)" & vbCrLf & vbCrLf
        strMsg(9) = "Click on any record in RoleAccessSelectFilter to view that filter's schema. Click Message to return to this message" & vbCrLf & vbCrLf
        strMsg(10) = "Then use the Create New Filter label to build new filter on server" & vbCrLf & vbCrLf
        strMsg(11) = "Cascading deletions are NOT in effect, except for the relationship involving the gateway table" & vbCrLf & vbCrLf
        strMsg(12) = "Additions to tables will fail if they violate underlying keys" & vbCrLf & vbCrLf
        strMsg(13) = "Click Refresh to manually refresh RoleAccessSelect if rows are accidently deleted (should not be required)" & vbCrLf & vbCrLf
        strMsg(14) = "Note that RoleAccessSelect may contain multiple records for a given gateway record if multiple roles are assigned to users.  However, the filtered apps will not see these duplications." & vbCrLf & vbCrLf
        strMsg(15) = "Note that RoleAccessColumn does not check if Column is a valid control name in any app" & vbCrLf & vbCrLf
        strMsg(16) = "Note that RoleAccessRow is not part of this app (easy to do)" & vbCrLf & vbCrLf
        For I = 0 To 16 ' Number of lines - 1
            tbMsg.AppendText(strMsg(I))
        Next I
        lblExecute.Visible = False
    End Sub
    Private Sub lblUser_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblUser.Click
        ' Declarations
        Dim str As String
        Dim prm As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Get name
        str = InputBox("Name of User?")
        If str = "" Then
            Exit Sub
        End If

        ' Define parameter for stored proc
        prm = New SqlClient.SqlParameter("@UserName", SqlDbType.NVarChar)
        prm.Value = str
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqAddUser"
        cmd.Parameters.Add(prm)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(1).Value = 0 Then
            MsgBox("Failed")
        Else
            FillUser()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub
    End Sub
    Private Sub FillUser()
        ' Declarations
        Dim str As String
        Dim cmd As New SqlCommand("", con)

        ' Open connection, if necessary
        If con.State = ConnectionState.Closed Then
            con.Open()
        End If

        ' Fill lbUser
        lbUser.Items.Clear()
        cmd.CommandText = "SELECT UserName FROM lkpUser ORDER BY UserName"
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str = reader.Item(0).ToString
            lbUser.Items.Add(str)
        End While
        reader.Close()

        ' Close connection
        con.Close()
    End Sub
    Private Sub FillRole()
        ' Declarations
        Dim str As String
        Dim cmd As New SqlCommand("", con)

        ' Open connection, if necessary
        If con.State = ConnectionState.Closed Then
            con.Open()
        End If

        ' Fill lbRole
        lbRole.Items.Clear()
        cmd.CommandText = "SELECT RoleName FROM lkpRole ORDER BY RoleName"
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str = reader.Item(0).ToString
            lbRole.Items.Add(str)
        End While
        reader.Close()

        ' Close connection
        con.Close()
    End Sub
    Private Sub FillView()
        ' Declarations
        Dim str As String
        Dim cmd As New SqlCommand("", con)

        ' Open connection, if necessary
        If con.State = ConnectionState.Closed Then
            con.Open()
        End If

        ' Fill
        lbView.Items.Clear()
        cmd.CommandText = "SELECT ViewName FROM lkpView ORDER BY ViewName"
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str = reader.Item(0).ToString
            lbView.Items.Add(str)
        End While
        reader.Close()

        ' Close connection
        con.Close()
    End Sub
    Private Sub FillUserRole()
        ' Declarations
        Dim str(2) As String
        Dim cmd As New SqlCommand("", con)

        ' Open connection, if necessary
        If con.State = ConnectionState.Closed Then
            con.Open()
        End If

        ' Fill
        lvUserRole.Items.Clear()
        cmd.CommandText = "SELECT lkpUser.UserName, lkpRole.RoleName FROM tblUserRole INNER JOIN lkpUser ON tblUserRole.UserId = lkpUser.UserId INNER JOIN lkpRole ON tblUserRole.RoleId = lkpRole.RoleId ORDER BY lkpUser.UserName, lkpRole.RoleName"
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str(0) = reader.Item(0).ToString
            str(1) = reader.Item(1).ToString
            lvUserRole.Items.Add(New ListViewItem(New String() {str(0), str(1)}))
        End While
        reader.Close()
        reader.Close()

        ' Close connection
        con.Close()
    End Sub
    Private Sub FillRoleAccessSelectFilter()
        ' Declarations
        Dim str(3) As String
        Dim cmd As New SqlCommand("", con)

        ' Open connection, if necessary
        If con.State = ConnectionState.Closed Then
            con.Open()
        End If

        ' Fill
        lvRoleAccessSelectFilter.Items.Clear()
        cmd.CommandText = "SELECT lkpRole.RoleName, lkpView.ViewName, tblRoleAccessSelectFilter.FilterName FROM lkpRole INNER JOIN tblRoleAccessSelectFilter ON lkpRole.RoleId = tblRoleAccessSelectFilter.RoleId INNER JOIN lkpView ON tblRoleAccessSelectFilter.ViewId = lkpView.ViewId ORDER BY lkpRole.RoleName, lkpView.ViewName, tblRoleAccessSelectFilter.FilterName"
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str(0) = reader.Item(0).ToString
            str(1) = reader.Item(1).ToString
            str(2) = reader.Item(2).ToString
            lvRoleAccessSelectFilter.Items.Add(New ListViewItem(New String() {str(0), str(1), str(2)}))
        End While
        reader.Close()

        ' Close connection
        con.Close()
    End Sub
    Private Sub FillAccessColumn()
        ' Declarations
        Dim str(2) As String
        Dim cmd As New SqlCommand("", con)

        ' Open connection, if necessary
        If con.State = ConnectionState.Closed Then
            con.Open()
        End If

        ' Fill
        lvAccessColumn.Items.Clear()
        cmd.CommandText = "SELECT AccessColumnName, Priority FROM lkpAccessColumn ORDER BY Priority"
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str(0) = reader.Item(0).ToString
            str(1) = reader.Item(1).ToString
            lvAccessColumn.Items.Add(New ListViewItem(New String() {str(0), str(1)}))
        End While
        reader.Close()

        ' Close connection
        con.Close()
    End Sub
    Private Sub FillRoleAccessColumn()
        ' Declarations
        Dim str(4) As String
        Dim cmd As New SqlCommand("", con)

        ' Open connection, if necessary
        If con.State = ConnectionState.Closed Then
            con.Open()
        End If

        ' Fill
        lvRoleAccessColumn.Items.Clear()
        cmd.CommandText = "SELECT lkpRole.RoleName, lkpView.ViewName, tblRoleAccessColumn.ColumnName, lkpAccessColumn.AccessColumnName FROM tblRoleAccessColumn INNER JOIN lkpAccessColumn ON tblRoleAccessColumn.AccessColumnId = lkpAccessColumn.AccessColumnId INNER JOIN lkpRole ON tblRoleAccessColumn.RoleId = lkpRole.RoleId INNER JOIN lkpView ON tblRoleAccessColumn.ViewId = lkpView.ViewId ORDER BY lkpRole.RoleName, lkpView.ViewName, tblRoleAccessColumn.ColumnName"
        Dim reader As SqlDataReader = cmd.ExecuteReader()
        While reader.Read()
            str(0) = reader.Item(0).ToString
            str(1) = reader.Item(1).ToString
            str(2) = reader.Item(2).ToString
            str(3) = reader.Item(3).ToString
            lvRoleAccessColumn.Items.Add(New ListViewItem(New String() {str(0), str(1), str(2), str(3)}))
        End While
        reader.Close()

        ' Close connection
        con.Close()
    End Sub
    Private Sub lblRole_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblRole.Click
        ' Declarations
        Dim str As String
        Dim prm As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Get name
        str = InputBox("Name of Role?")
        If str = "" Then
            Exit Sub
        End If

        ' Define parameter for stored proc
        prm = New SqlClient.SqlParameter("@RoleName", SqlDbType.NVarChar)
        prm.Value = str
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqAddRole"
        cmd.Parameters.Add(prm)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(1).Value = 0 Then
            MsgBox("Failed")
        Else
            FillRole()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub
    End Sub
    Private Sub lblView_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblView.Click
        ' Declarations
        Dim str As String
        Dim prm As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Get name
        str = InputBox("Name of View?")
        If str = "" Then
            Exit Sub
        End If

        ' Define parameter for stored proc
        prm = New SqlClient.SqlParameter("@ViewName", SqlDbType.NVarChar)
        prm.Value = str
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqAddView"
        cmd.Parameters.Add(prm)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(1).Value = 0 Then
            MsgBox("Failed")
        Else
            FillView()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub

    End Sub
    Private Sub lblUserRole_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblUserRole.Click
        ' Declarations
        Dim str(2) As String
        Dim prm1 As SqlClient.SqlParameter
        Dim prm2 As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Get User
        str(0) = InputBox("Name of User?")
        If str(0) = "" Then
            Exit Sub
        End If

        ' Get Role
        str(1) = InputBox("Name of Role?")
        If str(1) = "" Then
            Exit Sub
        End If

        ' Define parameter for stored proc
        prm1 = New SqlClient.SqlParameter("@UserName", SqlDbType.NVarChar)
        prm1.Value = str(0)
        prm2 = New SqlClient.SqlParameter("@RoleName", SqlDbType.NVarChar)
        prm2.Value = str(1)
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqAddUserRole"
        cmd.Parameters.Add(prm1)
        cmd.Parameters.Add(prm2)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(2).Value = 0 Then
            MsgBox("Failed")
        Else
            FillUserRole()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub

    End Sub
    Private Sub lblRoleAccessSelectFilter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblRoleAccessSelectFilter.Click
        ' Declarations
        Dim str(3) As String
        Dim prm1 As SqlClient.SqlParameter
        Dim prm2 As SqlClient.SqlParameter
        Dim prm3 As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Get Role
        str(0) = InputBox("Name of Role?")
        If str(0) = "" Then
            Exit Sub
        End If

        ' Get View
        str(1) = InputBox("Name of View?")
        If str(1) = "" Then
            Exit Sub
        End If

        ' Get Filter
        str(2) = InputBox("Name of Filter?")
        If str(2) = "" Then
            Exit Sub
        End If

        ' Define parameter for stored proc
        prm1 = New SqlClient.SqlParameter("@RoleName", SqlDbType.NVarChar)
        prm1.Value = str(0)
        prm2 = New SqlClient.SqlParameter("@ViewName", SqlDbType.NVarChar)
        prm2.Value = str(1)
        prm3 = New SqlClient.SqlParameter("@FilterName", SqlDbType.NVarChar)
        prm3.Value = str(2)
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqAddRoleAccessSelectFilter"
        cmd.Parameters.Add(prm1)
        cmd.Parameters.Add(prm2)
        cmd.Parameters.Add(prm3)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(3).Value = 0 Then
            MsgBox("Failed")
        Else
            FillRoleAccessSelectFilter()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub

    End Sub
    Private Sub lblRoleAccessSelectFilterDel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblRoleAccessSelectFilterDel.Click
        ' Declarations
        Dim str(3) As String
        Dim prm1 As SqlClient.SqlParameter
        Dim prm2 As SqlClient.SqlParameter
        Dim prm3 As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Check if record selected
        If lvRoleAccessSelectFilter.SelectedItems.Count <> 1 Then
            MsgBox("Must choose record")
            Exit Sub
        End If

        ' Get Role
        str(0) = lvRoleAccessSelectFilter.SelectedItems.Item(0).SubItems(0).Text

        ' Get View
        str(1) = lvRoleAccessSelectFilter.SelectedItems.Item(0).SubItems(1).Text


        ' Get Filter
        str(2) = lvRoleAccessSelectFilter.SelectedItems.Item(0).SubItems(2).Text

        ' Define parameter for stored proc
        prm1 = New SqlClient.SqlParameter("@RoleName", SqlDbType.NVarChar)
        prm1.Value = str(0)
        prm2 = New SqlClient.SqlParameter("@ViewName", SqlDbType.NVarChar)
        prm2.Value = str(1)
        prm3 = New SqlClient.SqlParameter("@FilterName", SqlDbType.NVarChar)
        prm3.Value = str(2)
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqDelRoleAccessSelectFilter"
        cmd.Parameters.Add(prm1)
        cmd.Parameters.Add(prm2)
        cmd.Parameters.Add(prm3)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(3).Value = 0 Then
            MsgBox("Failed")
        Else
            FillRoleAccessSelectFilter()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub
    End Sub
    Private Sub lblUserRoleDel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblUserRoleDel.Click
        ' Declarations
        Dim str(2) As String
        Dim prm1 As SqlClient.SqlParameter
        Dim prm2 As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Check if record selected
        If lvUserRole.SelectedItems.Count <> 1 Then
            MsgBox("Must choose record")
            Exit Sub
        End If

        ' Get User
        str(0) = lvUserRole.SelectedItems.Item(0).SubItems(0).Text

        ' Get Role
        str(1) = lvUserRole.SelectedItems.Item(0).SubItems(1).Text

        ' Define parameter for stored proc
        prm1 = New SqlClient.SqlParameter("@UserName", SqlDbType.NVarChar)
        prm1.Value = str(0)
        prm2 = New SqlClient.SqlParameter("@RoleName", SqlDbType.NVarChar)
        prm2.Value = str(1)
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqDelUserRole"
        cmd.Parameters.Add(prm1)
        cmd.Parameters.Add(prm2)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(2).Value = 0 Then
            MsgBox("Failed")
        Else
            FillUserRole()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub
    End Sub
    Private Sub lblUserDel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblUserDel.Click
        ' Declarations
        Dim str As String
        Dim prm As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Check if record selected
        If lbUser.SelectedItems.Count <> 1 Then
            MsgBox("Must choose record")
            Exit Sub
        End If

        ' Get name
        str = lbUser.SelectedItems.Item(0)

        ' Define parameter for stored proc
        prm = New SqlClient.SqlParameter("@UserName", SqlDbType.NVarChar)
        prm.Value = str
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqDelUser"
        cmd.Parameters.Add(prm)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(1).Value = 0 Then
            MsgBox("Failed")
        Else
            FillUser()
            FillUserRole()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub
    End Sub
    Private Sub lblRoleDel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblRoleDel.Click
        ' Declarations
        Dim str As String
        Dim prm As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Check if record selected
        If lbRole.SelectedItems.Count <> 1 Then
            MsgBox("Must choose record")
            Exit Sub
        End If

        ' Get name
        str = lbRole.SelectedItems.Item(0)

        ' Define parameter for stored proc
        prm = New SqlClient.SqlParameter("@RoleName", SqlDbType.NVarChar)
        prm.Value = str
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqDelRole"
        cmd.Parameters.Add(prm)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(1).Value = 0 Then
            MsgBox("Failed")
        Else
            FillRole()
            FillUserRole()
            FillRoleAccessSelectFilter()
            FillRoleAccessColumn()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub
    End Sub
    Private Sub lblViewDel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblViewDel.Click
        ' Declarations
        Dim str As String
        Dim prm As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Check if record selected
        If lbView.SelectedItems.Count <> 1 Then
            MsgBox("Must choose record")
            Exit Sub
        End If

        ' Get name
        str = lbView.SelectedItems.Item(0)

        ' Define parameter for stored proc
        prm = New SqlClient.SqlParameter("@ViewName", SqlDbType.NVarChar)
        prm.Value = str
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqDelView"
        cmd.Parameters.Add(prm)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(1).Value = 0 Then
            MsgBox("Failed")
        Else
            FillView()
            FillRoleAccessSelectFilter()
            FillRoleAccessColumn()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub
    End Sub
    Private Sub lblExecute_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblExecute.Click
        ' Declarations
        Dim cmd As New SqlCommand("", con)
        Dim rv As Int32

        ' Set up command to execute SQL
        cmd.CommandType = CommandType.Text
        cmd.CommandText = tbMsg.Text

        ' Open connection
        con.Open()

        ' Execute command
        On Error Resume Next
        rv = cmd.ExecuteNonQuery()

        ' Check for error

        If rv = 0 Then
            MsgBox("Failed")
        Else
            MsgBox("Success")
            lblExecute.Visible = False
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub
    End Sub
    Private Sub lblExecute_Hover(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblExecute.MouseHover
        ttExecute.SetToolTip(lblExecute, "Create new filter after changing Message")
    End Sub
    Private Sub lblSQL_Hover(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblSQL.MouseHover
        ttSQL.SetToolTip(lblSQL, "Use this to view current RoleAccessSelect query on server")
    End Sub
    Private Sub lblRoleAccessColumn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblRoleAccessColumn.Click
        ' Declarations
        Dim str(4) As String
        Dim prm1 As SqlClient.SqlParameter
        Dim prm2 As SqlClient.SqlParameter
        Dim prm3 As SqlClient.SqlParameter
        Dim prm4 As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Get Role
        str(0) = InputBox("Name of Role?")
        If str(0) = "" Then
            Exit Sub
        End If

        ' Get View
        str(1) = InputBox("Name of View?")
        If str(1) = "" Then
            Exit Sub
        End If

        ' Get Column
        str(2) = InputBox("Name of Column?")
        If str(2) = "" Then
            Exit Sub
        End If

        ' Get Access
        str(3) = InputBox("Name of Access (Lock, Hide, Full)?")
        If str(3) = "" Then
            Exit Sub
        End If

        ' Define parameter for stored proc
        prm1 = New SqlClient.SqlParameter("@RoleName", SqlDbType.NVarChar)
        prm1.Value = str(0)
        prm2 = New SqlClient.SqlParameter("@ViewName", SqlDbType.NVarChar)
        prm2.Value = str(1)
        prm3 = New SqlClient.SqlParameter("@ColumnName", SqlDbType.NVarChar)
        prm3.Value = str(2)
        prm4 = New SqlClient.SqlParameter("@AccessColumnName", SqlDbType.NVarChar)
        prm4.Value = str(3)
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqAddRoleAccessColumn"
        cmd.Parameters.Add(prm1)
        cmd.Parameters.Add(prm2)
        cmd.Parameters.Add(prm3)
        cmd.Parameters.Add(prm4)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(4).Value = 0 Then
            MsgBox("Failed")
        Else
            FillRoleAccessColumn()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub
    End Sub
    Private Sub lblRoleAccessColumnDel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblRoleAccessColumnDel.Click
        ' Declarations
        Dim str(4) As String
        Dim prm1 As SqlClient.SqlParameter
        Dim prm2 As SqlClient.SqlParameter
        Dim prm3 As SqlClient.SqlParameter
        Dim prm4 As SqlClient.SqlParameter
        Dim cmd As New SqlCommand("", con)
        Dim ROW_COUNT As SqlClient.SqlParameter

        ' Check if record selected
        If lvRoleAccessColumn.SelectedItems.Count <> 1 Then
            MsgBox("Must choose record")
            Exit Sub
        End If

        ' Get Role
        str(0) = lvRoleAccessColumn.SelectedItems.Item(0).SubItems(0).Text

        ' Get View
        str(1) = lvRoleAccessColumn.SelectedItems.Item(0).SubItems(1).Text

        ' Get Column
        str(2) = lvRoleAccessColumn.SelectedItems.Item(0).SubItems(2).Text

        ' Get Access
        str(3) = lvRoleAccessColumn.SelectedItems.Item(0).SubItems(3).Text

        ' Define parameter for stored proc
        prm1 = New SqlClient.SqlParameter("@RoleName", SqlDbType.NVarChar)
        prm1.Value = str(0)
        prm2 = New SqlClient.SqlParameter("@ViewName", SqlDbType.NVarChar)
        prm2.Value = str(1)
        prm3 = New SqlClient.SqlParameter("@ColumnName", SqlDbType.NVarChar)
        prm3.Value = str(2)
        prm4 = New SqlClient.SqlParameter("@AccessColumnName", SqlDbType.NVarChar)
        prm4.Value = str(3)
        ROW_COUNT = New SqlClient.SqlParameter("@ROW_COUNT", SqlDbType.Int)
        ROW_COUNT.Direction = ParameterDirection.InputOutput

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqDelRoleAccessColumn"
        cmd.Parameters.Add(prm1)
        cmd.Parameters.Add(prm2)
        cmd.Parameters.Add(prm3)
        cmd.Parameters.Add(prm4)
        cmd.Parameters.Add(ROW_COUNT)

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Check for error
        If cmd.Parameters.Item(4).Value = 0 Then
            MsgBox("Failed")
        Else
            FillRoleAccessColumn()
        End If

        ' Close connection
        con.Close()

        ' Exit
        Exit Sub
    End Sub
    Private Sub lblRoleAccessSelectRefresh_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblRoleAccessSelectRefresh.Click
        '
        ' Refresh security table
        '
        ' Effectively, this will delete all rows from tblRoleAccessSelectFilter (row by row) and then
        ' re-insert them (row by row) so the trigger on that table will synchronize tblRoleAccessSelect  
        ' with it.  This is necessary if, for example, some batch job deleted all rows in tblRoleAccessSelect 
        ' because that table's trigger is only fired on single insert/delete events.
        '

        ' Declarations
        Dim cmd As New SqlCommand("", con)

        ' Set up command to call to system stored proc
        cmd.CommandType = CommandType.StoredProcedure
        cmd.CommandText = "sqSyncronizeSecurityTable"

        ' Open connection
        con.Open()

        ' Execute command
        cmd.ExecuteNonQuery()

        ' Close connection
        con.Close()

        ' Refresh 
        lblRoleAccessSelect_Click(sender, e)

        ' Exit
        Exit Sub
    End Sub
End Class
